# Big5 LCD Font test -- 2018/10/24 tklua@wifiboy.org
# Encoding Converter https://r12a.github.io/app-encodings/
# https://sou-yun.com/Query.aspx?type=poem1&id=582265

def b5offset(x):
    x1=x>>8; x2=x%256
    n=(x1-161)*5024+362
    if (x2<127): n+=(x2-64)*32
    else: n+=(x2-98)*32
    return n

def showch(b, x, y, c):
    for i in range(16):
        for j in range(8):
            if b[2*i]&(2**(7-j)): wb.pix(x+j, y+i, c); 
        for j in range(8):
            if b[2*i+1]&(2**(7-j)): wb.pix(x+j+8, y+i, c); 

def showb5(s, x, y, c):
    with open("/sd/font/FB516F.PDB","rb") as f:
        for ch in s:
            f.seek(b5offset(ch))
            showch(f.read(32), x, y, c)
            x+=16
        f.close()

wb.cls()
b5str=[0xA443,0xA8A5,0xB5B4,0xA579]
showb5(b5str, 0, 5,  wb.LIGHTGREY)
b5str=[0xA650,0xA448,0xA454,0xA4AD,0xBAC9,0xADB8,0xC16E,0xA141]
showb5(b5str, 0, 30, wb.CYAN)
b5str=[0xAEDB,0xAD62,0xBA69,0xB6A5,0xBDF1,0xAE6A,0xA6E6,0xA143]
showb5(b5str, 0, 52, wb.GREEN)
b5str=[0xB05A,0xABDD,0xC0C4,0xC2C3,0xA454,0xB8FC,0xABE1,0xA141]
showb5(b5str, 0, 74, wb.PINK)
b5str=[0xA440,0xBBEF,0xA4E8,0xA96C,0xB855,0xA448,0xC5E5,0xA143]
showb5(b5str, 0, 96, wb.YELLOW)
  